/*
 * Decompiled with CFR 0.152.
 */
package Calc4M;

import Calc4M.Settings;
import ral.Real;

public class StackElement {
    public static final int EditingNumber = 1;
    public static final int FinishedNumber = 2;
    public static final int LeftParanthesis = 3;
    public static final int CalcAddition = 4;
    public static final int CalcSubtraction = 5;
    public static final int CalcMultiplication = 6;
    public static final int CalcDivision = 7;
    public static final int CalcRaised = 8;
    private Real value;
    private String valueString = null;
    private int calcType;

    public StackElement(int calcType) {
        this.calcType = calcType;
    }

    public StackElement(Real value) {
        this.calcType = 2;
        this.value = value;
    }

    public StackElement(String valueString) {
        this.calcType = 1;
        this.valueString = valueString;
    }

    public int getCalcType() {
        return this.calcType;
    }

    public Real getValue() {
        switch (this.calcType) {
            case 2: {
                return this.value;
            }
            case 1: {
                return new Real(this.valueString, Settings.getCalcBase());
            }
        }
        return null;
    }

    public int getPriority() {
        switch (this.calcType) {
            case 4: 
            case 5: {
                return 1;
            }
            case 6: 
            case 7: {
                return 2;
            }
            case 8: {
                return 3;
            }
            case 3: {
                return -1;
            }
        }
        return 0;
    }

    public String toString() {
        return this.toString(null);
    }

    public String toString(Real.NumberFormat format) {
        switch (this.calcType) {
            case 1: {
                return this.valueString;
            }
            case 2: {
                if (format == null) {
                    return this.value.toString();
                }
                return this.value.toString(format);
            }
            case 3: {
                return "(";
            }
            case 4: {
                return "+";
            }
            case 5: {
                return "-";
            }
            case 6: {
                return "*";
            }
            case 7: {
                return "/";
            }
            case 8: {
                return "^";
            }
        }
        return "";
    }

    public void addToValueString(char ch) {
        if (this.valueString.indexOf(ch) > 0 && (ch == 'e' || ch == '.') || ch == '.' && this.valueString.indexOf("e") > 0) {
            return;
        }
        if (ch == '-') {
            this.valueString = this.valueString.indexOf("e") == this.valueString.length() - 1 ? this.valueString + ch : (this.valueString.indexOf("-") == 0 ? this.valueString.substring(1) : "-" + this.valueString);
            return;
        }
        this.valueString = this.valueString + ch;
    }

    public void addToValueString(int i) {
        this.valueString = this.valueString + i;
    }

    public void setValueString(String valueString) {
        this.valueString = valueString;
    }

    public String getValueString() {
        return this.valueString;
    }

    public boolean isValue() {
        return this.calcType == 1 || this.calcType == 2;
    }

    public boolean isEditingNumberEmpty() {
        return this.calcType == 1 && this.valueString.length() == 0;
    }
}

